// admins
local CAdmins	= OOP_Derive( CHook, CDatabase, CCommand );

// constructor.
function CAdmins:__ctor( )
	// hook event
	self:HookEvent( "PlayerInitialSpawn" );
	
	// hook commands
	self:HookCommand( "VMF_AddAdmin" );
	self:HookCommand( "VMF_RemoveAdmin" );
	self:HookCommand( "VMF_UpdateAdmin" );

	// setup the flags table.
	if( !self:TableExists( "vmfsuite_admins" ) ) then
		// create the table.
		self:Query(
			"CREATE TABLE IF NOT EXISTS vmfsuite_admins ( name VARCHAR(255), steamid VARCHAR(32), flags VARCHAR(32) );"
		);
	
	end
	
	
end


// add admin
function CAdmins:OnVMF_AddAdmin( pl, args )
	// access flag + which gives us almost superadmin ability!
	if( !self:HasAccess( pl, '+' ) ) then return; end
	
	// add :D
	local steamid = args[1] or "UNKNOWN";
	local flags = args[2] or "";
	local name = args[3] or "Unnamed";
	
	// die!
	self:Query(
		"INSERT INTO vmfsuite_admins ( name, steamid, flags ) VALUES( '" .. name .. "', '" .. steamid .. "', '" .. flags .. "' )"
	);
	
	// update.
	umsg.Start( "Admin", pl );
		umsg.String( name );
		umsg.String( steamid );
		umsg.String( flags );
	umsg.End();
		
end

// remove admin
function CAdmins:OnVMF_RemoveAdmin( pl, args )
	// access flag + which gives us almost superadmin ability!
	if( !self:HasAccess( pl, '+' ) ) then return; end
	
	// lets kill it! kill it with fire!
	local steamid = args[1] or "UNKNOWN";
	
	// die!
	self:Query(
		"DELETE FROM vmfsuite_admins WHERE steamid = '" .. steamid .. "'"
	);
	
	// update.
	umsg.Start( "RemoveAdmin", pl );
		umsg.String( steamid );
	umsg.End();

end

// update admin
function CAdmins:OnVMF_UpdateAdmin( pl, args )
	// access flag + which gives us almost superadmin ability!
	if( !self:HasAccess( pl, '+' ) ) then return; end
	
	// update
	local steamid = args[1] or "UNKNOWN";
	local flags = args[2] or "";
	local name = args[3] or "Unnamed";
	
	// die!
	self:Query(
		"UPDATE vmfsuite_admins SET flags = '" .. flags .. "', name = '" .. name .. "' WHERE steamid = '" .. steamid .. "'"
	);

end



// player has flag?
function CAdmins:HasAccess( pl, flag )
	// superadmins always have access!
	if( pl:IsSuperAdmin() ) then return true; end
	
	// no flag?
	if( !flag || flag == "" ) then return true; end
	
	// fetch our admin list
	local results = self:Query(
		"SELECT flags FROM vmfsuite_admins WHERE steamid = '" .. pl:SteamID() .. "'"
	);
	if( !results ) then return false; end
	
	// has the flag?
	if( string.find( results[1].flags, flag ) ) then return true; end
	
	// nothing found
	return false;

end




// Player spawned
function CAdmins:OnPlayerInitialSpawn( pl )
	// store our steamid as a networked string.
	pl:SetNetworkedString( "steamid", pl:SteamID() );

	// read admins from the database.
	local results = self:Query(
		"SELECT * FROM vmfsuite_admins"
	);
	if( !results ) then return; end
	
	// send the admins to the client.
	local i;
	for i = 1, table.getn( results ) do
		// admin
		local admin = results[i];

		// send
		umsg.Start( "Admin", pl );
			umsg.String( admin.name );
			umsg.String( admin.steamid );
			umsg.String( admin.flags );
		umsg.End();
	
	end
	
end

// create.
VMFSuite.AdminSystem = CAdmins:create();
